<?php

namespace Statamic\Dictionaries;

use Illuminate\Support\Collection;

class Countries extends BasicDictionary
{
    protected string $valueKey = 'iso3';
    protected array $searchable = ['name', 'iso3'];
    protected array $keywords = ['countries', 'country'];
    private array $regions;
    private array $subregions;

    public function __construct()
    {
        $this->regions = [
            'africa' => __('statamic::dictionary-countries.regions.africa'),
            'americas' => __('statamic::dictionary-countries.regions.americas'),
            'asia' => __('statamic::dictionary-countries.regions.asia'),
            'europe' => __('statamic::dictionary-countries.regions.europe'),
            'oceania' => __('statamic::dictionary-countries.regions.oceania'),
            'polar' => __('statamic::dictionary-countries.regions.polar'),
        ];

        $this->subregions = [
            'australia_new_zealand' => __('statamic::dictionary-countries.subregions.australia_new_zealand'),
            'caribbean' => __('statamic::dictionary-countries.subregions.caribbean'),
            'central_africa' => __('statamic::dictionary-countries.subregions.central_africa'),
            'central_america' => __('statamic::dictionary-countries.subregions.central_america'),
            'central_asia' => __('statamic::dictionary-countries.subregions.central_asia'),
            'eastern_africa' => __('statamic::dictionary-countries.subregions.eastern_africa'),
            'eastern_asia' => __('statamic::dictionary-countries.subregions.eastern_asia'),
            'eastern_europe' => __('statamic::dictionary-countries.subregions.eastern_europe'),
            'melanesia' => __('statamic::dictionary-countries.subregions.melanesia'),
            'micronesia' => __('statamic::dictionary-countries.subregions.micronesia'),
            'northern_africa' => __('statamic::dictionary-countries.subregions.northern_africa'),
            'northern_america' => __('statamic::dictionary-countries.subregions.northern_america'),
            'northern_europe' => __('statamic::dictionary-countries.subregions.northern_europe'),
            'polynesia' => __('statamic::dictionary-countries.subregions.polynesia'),
            'southern_africa' => __('statamic::dictionary-countries.subregions.southern_africa'),
            'southern_asia' => __('statamic::dictionary-countries.subregions.southern_asia'),
            'southern_europe' => __('statamic::dictionary-countries.subregions.southern_europe'),
            'south_america' => __('statamic::dictionary-countries.subregions.south_america'),
            'south_eastern_africa' => __('statamic::dictionary-countries.subregions.south_eastern_africa'),
            'south_eastern_asia' => __('statamic::dictionary-countries.subregions.south_eastern_asia'),
            'western_africa' => __('statamic::dictionary-countries.subregions.western_africa'),
            'western_asia' => __('statamic::dictionary-countries.subregions.western_asia'),
            'western_europe' => __('statamic::dictionary-countries.subregions.western_europe'),
        ];
    }

    protected function getItemLabel(array $item): string
    {
        return vsprintf('%s%s', [
            ($this->config['emojis'] ?? true) ? "{$item['emoji']} " : '',
            $item['name'],
        ]);
    }

    protected function fieldItems()
    {
        return [
            'region' => [
                'display' => __('Region'),
                'instructions' => __('statamic::messages.dictionaries_countries_region_instructions'),
                'type' => 'select',
                'options' => $this->regions,
            ],
            'emojis' => [
                'display' => __('Emojis'),
                'instructions' => __('statamic::messages.dictionaries_countries_emojis_instructions'),
                'type' => 'toggle',
                'default' => true,
            ],
        ];
    }

    protected function getFilteredItems(): Collection
    {
        return $this
            ->collectItems()
            ->when($this->config['region'] ?? false, fn ($collection, $region) => $collection->where('region', $this->regions[$region]));
    }

    protected function getItems(): array
    {
        return [
            ['name' => __('statamic::dictionary-countries.names.AFG'), 'iso3' => 'AFG', 'iso2' => 'AF', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇦🇫'],
            ['name' => __('statamic::dictionary-countries.names.ALA'), 'iso3' => 'ALA', 'iso2' => 'AX', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇦🇽'],
            ['name' => __('statamic::dictionary-countries.names.ALB'), 'iso3' => 'ALB', 'iso2' => 'AL', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇦🇱'],
            ['name' => __('statamic::dictionary-countries.names.DZA'), 'iso3' => 'DZA', 'iso2' => 'DZ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇩🇿'],
            ['name' => __('statamic::dictionary-countries.names.ASM'), 'iso3' => 'ASM', 'iso2' => 'AS', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇦🇸'],
            ['name' => __('statamic::dictionary-countries.names.AND'), 'iso3' => 'AND', 'iso2' => 'AD', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇦🇩'],
            ['name' => __('statamic::dictionary-countries.names.AGO'), 'iso3' => 'AGO', 'iso2' => 'AO', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇦🇴'],
            ['name' => __('statamic::dictionary-countries.names.AIA'), 'iso3' => 'AIA', 'iso2' => 'AI', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇦🇮'],
            ['name' => __('statamic::dictionary-countries.names.ATA'), 'iso3' => 'ATA', 'iso2' => 'AQ', 'region' => $this->regions['polar'], 'subregion' => '', 'emoji' => '🇦🇶'],
            ['name' => __('statamic::dictionary-countries.names.ATG'), 'iso3' => 'ATG', 'iso2' => 'AG', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇦🇬'],
            ['name' => __('statamic::dictionary-countries.names.ARG'), 'iso3' => 'ARG', 'iso2' => 'AR', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇦🇷'],
            ['name' => __('statamic::dictionary-countries.names.ARM'), 'iso3' => 'ARM', 'iso2' => 'AM', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇦🇲'],
            ['name' => __('statamic::dictionary-countries.names.ABW'), 'iso3' => 'ABW', 'iso2' => 'AW', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇦🇼'],
            ['name' => __('statamic::dictionary-countries.names.AUS'), 'iso3' => 'AUS', 'iso2' => 'AU', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['australia_new_zealand'], 'emoji' => '🇦🇺'],
            ['name' => __('statamic::dictionary-countries.names.AUT'), 'iso3' => 'AUT', 'iso2' => 'AT', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇦🇹'],
            ['name' => __('statamic::dictionary-countries.names.AZE'), 'iso3' => 'AZE', 'iso2' => 'AZ', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇦🇿'],
            ['name' => __('statamic::dictionary-countries.names.BHS'), 'iso3' => 'BHS', 'iso2' => 'BS', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇧🇸'],
            ['name' => __('statamic::dictionary-countries.names.BHR'), 'iso3' => 'BHR', 'iso2' => 'BH', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇧🇭'],
            ['name' => __('statamic::dictionary-countries.names.BGD'), 'iso3' => 'BGD', 'iso2' => 'BD', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇧🇩'],
            ['name' => __('statamic::dictionary-countries.names.BRB'), 'iso3' => 'BRB', 'iso2' => 'BB', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇧🇧'],
            ['name' => __('statamic::dictionary-countries.names.BLR'), 'iso3' => 'BLR', 'iso2' => 'BY', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇧🇾'],
            ['name' => __('statamic::dictionary-countries.names.BEL'), 'iso3' => 'BEL', 'iso2' => 'BE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇧🇪'],
            ['name' => __('statamic::dictionary-countries.names.BLZ'), 'iso3' => 'BLZ', 'iso2' => 'BZ', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇧🇿'],
            ['name' => __('statamic::dictionary-countries.names.BEN'), 'iso3' => 'BEN', 'iso2' => 'BJ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇧🇯'],
            ['name' => __('statamic::dictionary-countries.names.BMU'), 'iso3' => 'BMU', 'iso2' => 'BM', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇧🇲'],
            ['name' => __('statamic::dictionary-countries.names.BTN'), 'iso3' => 'BTN', 'iso2' => 'BT', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇧🇹'],
            ['name' => __('statamic::dictionary-countries.names.BOL'), 'iso3' => 'BOL', 'iso2' => 'BO', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇧🇴'],
            ['name' => __('statamic::dictionary-countries.names.BES'), 'iso3' => 'BES', 'iso2' => 'BQ', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇧🇶'],
            ['name' => __('statamic::dictionary-countries.names.BIH'), 'iso3' => 'BIH', 'iso2' => 'BA', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇧🇦'],
            ['name' => __('statamic::dictionary-countries.names.BWA'), 'iso3' => 'BWA', 'iso2' => 'BW', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇧🇼'],
            ['name' => __('statamic::dictionary-countries.names.BVT'), 'iso3' => 'BVT', 'iso2' => 'BV', 'region' => '', 'subregion' => '', 'emoji' => '🇧🇻'],
            ['name' => __('statamic::dictionary-countries.names.BRA'), 'iso3' => 'BRA', 'iso2' => 'BR', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇧🇷'],
            ['name' => __('statamic::dictionary-countries.names.IOT'), 'iso3' => 'IOT', 'iso2' => 'IO', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇮🇴'],
            ['name' => __('statamic::dictionary-countries.names.BRN'), 'iso3' => 'BRN', 'iso2' => 'BN', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇧🇳'],
            ['name' => __('statamic::dictionary-countries.names.BGR'), 'iso3' => 'BGR', 'iso2' => 'BG', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇧🇬'],
            ['name' => __('statamic::dictionary-countries.names.BFA'), 'iso3' => 'BFA', 'iso2' => 'BF', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇧🇫'],
            ['name' => __('statamic::dictionary-countries.names.BDI'), 'iso3' => 'BDI', 'iso2' => 'BI', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇧🇮'],
            ['name' => __('statamic::dictionary-countries.names.KHM'), 'iso3' => 'KHM', 'iso2' => 'KH', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇰🇭'],
            ['name' => __('statamic::dictionary-countries.names.CMR'), 'iso3' => 'CMR', 'iso2' => 'CM', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇨🇲'],
            ['name' => __('statamic::dictionary-countries.names.CAN'), 'iso3' => 'CAN', 'iso2' => 'CA', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇨🇦'],
            ['name' => __('statamic::dictionary-countries.names.CPV'), 'iso3' => 'CPV', 'iso2' => 'CV', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇨🇻'],
            ['name' => __('statamic::dictionary-countries.names.CYM'), 'iso3' => 'CYM', 'iso2' => 'KY', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇰🇾'],
            ['name' => __('statamic::dictionary-countries.names.CAF'), 'iso3' => 'CAF', 'iso2' => 'CF', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇨🇫'],
            ['name' => __('statamic::dictionary-countries.names.TCD'), 'iso3' => 'TCD', 'iso2' => 'TD', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇹🇩'],
            ['name' => __('statamic::dictionary-countries.names.CHL'), 'iso3' => 'CHL', 'iso2' => 'CL', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇨🇱'],
            ['name' => __('statamic::dictionary-countries.names.CHN'), 'iso3' => 'CHN', 'iso2' => 'CN', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇨🇳'],
            ['name' => __('statamic::dictionary-countries.names.CXR'), 'iso3' => 'CXR', 'iso2' => 'CX', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['australia_new_zealand'], 'emoji' => '🇨🇽'],
            ['name' => __('statamic::dictionary-countries.names.CCK'), 'iso3' => 'CCK', 'iso2' => 'CC', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['australia_new_zealand'], 'emoji' => '🇨🇨'],
            ['name' => __('statamic::dictionary-countries.names.COL'), 'iso3' => 'COL', 'iso2' => 'CO', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇨🇴'],
            ['name' => __('statamic::dictionary-countries.names.COM'), 'iso3' => 'COM', 'iso2' => 'KM', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇰🇲'],
            ['name' => __('statamic::dictionary-countries.names.COG'), 'iso3' => 'COG', 'iso2' => 'CG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇨🇬'],
            ['name' => __('statamic::dictionary-countries.names.COK'), 'iso3' => 'COK', 'iso2' => 'CK', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇨🇰'],
            ['name' => __('statamic::dictionary-countries.names.CRI'), 'iso3' => 'CRI', 'iso2' => 'CR', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇨🇷'],
            ['name' => __('statamic::dictionary-countries.names.CIV'), 'iso3' => 'CIV', 'iso2' => 'CI', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇨🇮'],
            ['name' => __('statamic::dictionary-countries.names.HRV'), 'iso3' => 'HRV', 'iso2' => 'HR', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇭🇷'],
            ['name' => __('statamic::dictionary-countries.names.CUB'), 'iso3' => 'CUB', 'iso2' => 'CU', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇨🇺'],
            ['name' => __('statamic::dictionary-countries.names.CUW'), 'iso3' => 'CUW', 'iso2' => 'CW', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇨🇼'],
            ['name' => __('statamic::dictionary-countries.names.CYP'), 'iso3' => 'CYP', 'iso2' => 'CY', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇨🇾'],
            ['name' => __('statamic::dictionary-countries.names.CZE'), 'iso3' => 'CZE', 'iso2' => 'CZ', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇨🇿'],
            ['name' => __('statamic::dictionary-countries.names.COD'), 'iso3' => 'COD', 'iso2' => 'CD', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇨🇩'],
            ['name' => __('statamic::dictionary-countries.names.DNK'), 'iso3' => 'DNK', 'iso2' => 'DK', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇩🇰'],
            ['name' => __('statamic::dictionary-countries.names.DJI'), 'iso3' => 'DJI', 'iso2' => 'DJ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇩🇯'],
            ['name' => __('statamic::dictionary-countries.names.DMA'), 'iso3' => 'DMA', 'iso2' => 'DM', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇩🇲'],
            ['name' => __('statamic::dictionary-countries.names.DOM'), 'iso3' => 'DOM', 'iso2' => 'DO', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇩🇴'],
            ['name' => __('statamic::dictionary-countries.names.TLS'), 'iso3' => 'TLS', 'iso2' => 'TL', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇹🇱'],
            ['name' => __('statamic::dictionary-countries.names.ECU'), 'iso3' => 'ECU', 'iso2' => 'EC', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇪🇨'],
            ['name' => __('statamic::dictionary-countries.names.EGY'), 'iso3' => 'EGY', 'iso2' => 'EG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇪🇬'],
            ['name' => __('statamic::dictionary-countries.names.SLV'), 'iso3' => 'SLV', 'iso2' => 'SV', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇸🇻'],
            ['name' => __('statamic::dictionary-countries.names.GNQ'), 'iso3' => 'GNQ', 'iso2' => 'GQ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇬🇶'],
            ['name' => __('statamic::dictionary-countries.names.ERI'), 'iso3' => 'ERI', 'iso2' => 'ER', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇪🇷'],
            ['name' => __('statamic::dictionary-countries.names.EST'), 'iso3' => 'EST', 'iso2' => 'EE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇪🇪'],
            ['name' => __('statamic::dictionary-countries.names.ETH'), 'iso3' => 'ETH', 'iso2' => 'ET', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇪🇹'],
            ['name' => __('statamic::dictionary-countries.names.FLK'), 'iso3' => 'FLK', 'iso2' => 'FK', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇫🇰'],
            ['name' => __('statamic::dictionary-countries.names.FRO'), 'iso3' => 'FRO', 'iso2' => 'FO', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇫🇴'],
            ['name' => __('statamic::dictionary-countries.names.FJI'), 'iso3' => 'FJI', 'iso2' => 'FJ', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['melanesia'], 'emoji' => '🇫🇯'],
            ['name' => __('statamic::dictionary-countries.names.FIN'), 'iso3' => 'FIN', 'iso2' => 'FI', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇫🇮'],
            ['name' => __('statamic::dictionary-countries.names.FRA'), 'iso3' => 'FRA', 'iso2' => 'FR', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇫🇷'],
            ['name' => __('statamic::dictionary-countries.names.GUF'), 'iso3' => 'GUF', 'iso2' => 'GF', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇬🇫'],
            ['name' => __('statamic::dictionary-countries.names.PYF'), 'iso3' => 'PYF', 'iso2' => 'PF', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇵🇫'],
            ['name' => __('statamic::dictionary-countries.names.ATF'), 'iso3' => 'ATF', 'iso2' => 'TF', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇹🇫'],
            ['name' => __('statamic::dictionary-countries.names.GAB'), 'iso3' => 'GAB', 'iso2' => 'GA', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇬🇦'],
            ['name' => __('statamic::dictionary-countries.names.GMB'), 'iso3' => 'GMB', 'iso2' => 'GM', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇬🇲'],
            ['name' => __('statamic::dictionary-countries.names.GEO'), 'iso3' => 'GEO', 'iso2' => 'GE', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇬🇪'],
            ['name' => __('statamic::dictionary-countries.names.DEU'), 'iso3' => 'DEU', 'iso2' => 'DE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇩🇪'],
            ['name' => __('statamic::dictionary-countries.names.GHA'), 'iso3' => 'GHA', 'iso2' => 'GH', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇬🇭'],
            ['name' => __('statamic::dictionary-countries.names.GIB'), 'iso3' => 'GIB', 'iso2' => 'GI', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇬🇮'],
            ['name' => __('statamic::dictionary-countries.names.GRC'), 'iso3' => 'GRC', 'iso2' => 'GR', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇬🇷'],
            ['name' => __('statamic::dictionary-countries.names.GRL'), 'iso3' => 'GRL', 'iso2' => 'GL', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇬🇱'],
            ['name' => __('statamic::dictionary-countries.names.GRD'), 'iso3' => 'GRD', 'iso2' => 'GD', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇬🇩'],
            ['name' => __('statamic::dictionary-countries.names.GLP'), 'iso3' => 'GLP', 'iso2' => 'GP', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇬🇵'],
            ['name' => __('statamic::dictionary-countries.names.GUM'), 'iso3' => 'GUM', 'iso2' => 'GU', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇬🇺'],
            ['name' => __('statamic::dictionary-countries.names.GTM'), 'iso3' => 'GTM', 'iso2' => 'GT', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇬🇹'],
            ['name' => __('statamic::dictionary-countries.names.GGY'), 'iso3' => 'GGY', 'iso2' => 'GG', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇬🇬'],
            ['name' => __('statamic::dictionary-countries.names.GIN'), 'iso3' => 'GIN', 'iso2' => 'GN', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇬🇳'],
            ['name' => __('statamic::dictionary-countries.names.GNB'), 'iso3' => 'GNB', 'iso2' => 'GW', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇬🇼'],
            ['name' => __('statamic::dictionary-countries.names.GUY'), 'iso3' => 'GUY', 'iso2' => 'GY', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇬🇾'],
            ['name' => __('statamic::dictionary-countries.names.HTI'), 'iso3' => 'HTI', 'iso2' => 'HT', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇭🇹'],
            ['name' => __('statamic::dictionary-countries.names.HMD'), 'iso3' => 'HMD', 'iso2' => 'HM', 'region' => '', 'subregion' => '', 'emoji' => '🇭🇲'],
            ['name' => __('statamic::dictionary-countries.names.HND'), 'iso3' => 'HND', 'iso2' => 'HN', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇭🇳'],
            ['name' => __('statamic::dictionary-countries.names.HKG'), 'iso3' => 'HKG', 'iso2' => 'HK', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇭🇰'],
            ['name' => __('statamic::dictionary-countries.names.HUN'), 'iso3' => 'HUN', 'iso2' => 'HU', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇭🇺'],
            ['name' => __('statamic::dictionary-countries.names.ISL'), 'iso3' => 'ISL', 'iso2' => 'IS', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇮🇸'],
            ['name' => __('statamic::dictionary-countries.names.IND'), 'iso3' => 'IND', 'iso2' => 'IN', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇮🇳'],
            ['name' => __('statamic::dictionary-countries.names.IDN'), 'iso3' => 'IDN', 'iso2' => 'ID', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇮🇩'],
            ['name' => __('statamic::dictionary-countries.names.IRN'), 'iso3' => 'IRN', 'iso2' => 'IR', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇮🇷'],
            ['name' => __('statamic::dictionary-countries.names.IRQ'), 'iso3' => 'IRQ', 'iso2' => 'IQ', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇮🇶'],
            ['name' => __('statamic::dictionary-countries.names.IRL'), 'iso3' => 'IRL', 'iso2' => 'IE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇮🇪'],
            ['name' => __('statamic::dictionary-countries.names.ISR'), 'iso3' => 'ISR', 'iso2' => 'IL', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇮🇱'],
            ['name' => __('statamic::dictionary-countries.names.ITA'), 'iso3' => 'ITA', 'iso2' => 'IT', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇮🇹'],
            ['name' => __('statamic::dictionary-countries.names.JAM'), 'iso3' => 'JAM', 'iso2' => 'JM', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇯🇲'],
            ['name' => __('statamic::dictionary-countries.names.JPN'), 'iso3' => 'JPN', 'iso2' => 'JP', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇯🇵'],
            ['name' => __('statamic::dictionary-countries.names.JEY'), 'iso3' => 'JEY', 'iso2' => 'JE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇯🇪'],
            ['name' => __('statamic::dictionary-countries.names.JOR'), 'iso3' => 'JOR', 'iso2' => 'JO', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇯🇴'],
            ['name' => __('statamic::dictionary-countries.names.KAZ'), 'iso3' => 'KAZ', 'iso2' => 'KZ', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['central_asia'], 'emoji' => '🇰🇿'],
            ['name' => __('statamic::dictionary-countries.names.KEN'), 'iso3' => 'KEN', 'iso2' => 'KE', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇰🇪'],
            ['name' => __('statamic::dictionary-countries.names.KIR'), 'iso3' => 'KIR', 'iso2' => 'KI', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇰🇮'],
            ['name' => __('statamic::dictionary-countries.names.XKX'), 'iso3' => 'XKX', 'iso2' => 'XK', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇽🇰'],
            ['name' => __('statamic::dictionary-countries.names.KWT'), 'iso3' => 'KWT', 'iso2' => 'KW', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇰🇼'],
            ['name' => __('statamic::dictionary-countries.names.KGZ'), 'iso3' => 'KGZ', 'iso2' => 'KG', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['central_asia'], 'emoji' => '🇰🇬'],
            ['name' => __('statamic::dictionary-countries.names.LAO'), 'iso3' => 'LAO', 'iso2' => 'LA', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇱🇦'],
            ['name' => __('statamic::dictionary-countries.names.LVA'), 'iso3' => 'LVA', 'iso2' => 'LV', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇱🇻'],
            ['name' => __('statamic::dictionary-countries.names.LBN'), 'iso3' => 'LBN', 'iso2' => 'LB', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇱🇧'],
            ['name' => __('statamic::dictionary-countries.names.LSO'), 'iso3' => 'LSO', 'iso2' => 'LS', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇱🇸'],
            ['name' => __('statamic::dictionary-countries.names.LBR'), 'iso3' => 'LBR', 'iso2' => 'LR', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇱🇷'],
            ['name' => __('statamic::dictionary-countries.names.LBY'), 'iso3' => 'LBY', 'iso2' => 'LY', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇱🇾'],
            ['name' => __('statamic::dictionary-countries.names.LIE'), 'iso3' => 'LIE', 'iso2' => 'LI', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇱🇮'],
            ['name' => __('statamic::dictionary-countries.names.LTU'), 'iso3' => 'LTU', 'iso2' => 'LT', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇱🇹'],
            ['name' => __('statamic::dictionary-countries.names.LUX'), 'iso3' => 'LUX', 'iso2' => 'LU', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇱🇺'],
            ['name' => __('statamic::dictionary-countries.names.MAC'), 'iso3' => 'MAC', 'iso2' => 'MO', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇲🇴'],
            ['name' => __('statamic::dictionary-countries.names.MKD'), 'iso3' => 'MKD', 'iso2' => 'MK', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇲🇰'],
            ['name' => __('statamic::dictionary-countries.names.MDG'), 'iso3' => 'MDG', 'iso2' => 'MG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇲🇬'],
            ['name' => __('statamic::dictionary-countries.names.MWI'), 'iso3' => 'MWI', 'iso2' => 'MW', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇲🇼'],
            ['name' => __('statamic::dictionary-countries.names.MYS'), 'iso3' => 'MYS', 'iso2' => 'MY', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇲🇾'],
            ['name' => __('statamic::dictionary-countries.names.MDV'), 'iso3' => 'MDV', 'iso2' => 'MV', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇲🇻'],
            ['name' => __('statamic::dictionary-countries.names.MLI'), 'iso3' => 'MLI', 'iso2' => 'ML', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇲🇱'],
            ['name' => __('statamic::dictionary-countries.names.MLT'), 'iso3' => 'MLT', 'iso2' => 'MT', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇲🇹'],
            ['name' => __('statamic::dictionary-countries.names.IMN'), 'iso3' => 'IMN', 'iso2' => 'IM', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇮🇲'],
            ['name' => __('statamic::dictionary-countries.names.MHL'), 'iso3' => 'MHL', 'iso2' => 'MH', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇲🇭'],
            ['name' => __('statamic::dictionary-countries.names.MTQ'), 'iso3' => 'MTQ', 'iso2' => 'MQ', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇲🇶'],
            ['name' => __('statamic::dictionary-countries.names.MRT'), 'iso3' => 'MRT', 'iso2' => 'MR', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇲🇷'],
            ['name' => __('statamic::dictionary-countries.names.MUS'), 'iso3' => 'MUS', 'iso2' => 'MU', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇲🇺'],
            ['name' => __('statamic::dictionary-countries.names.MYT'), 'iso3' => 'MYT', 'iso2' => 'YT', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇾🇹'],
            ['name' => __('statamic::dictionary-countries.names.MEX'), 'iso3' => 'MEX', 'iso2' => 'MX', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇲🇽'],
            ['name' => __('statamic::dictionary-countries.names.FSM'), 'iso3' => 'FSM', 'iso2' => 'FM', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇫🇲'],
            ['name' => __('statamic::dictionary-countries.names.MDA'), 'iso3' => 'MDA', 'iso2' => 'MD', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇲🇩'],
            ['name' => __('statamic::dictionary-countries.names.MCO'), 'iso3' => 'MCO', 'iso2' => 'MC', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇲🇨'],
            ['name' => __('statamic::dictionary-countries.names.MNG'), 'iso3' => 'MNG', 'iso2' => 'MN', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇲🇳'],
            ['name' => __('statamic::dictionary-countries.names.MNE'), 'iso3' => 'MNE', 'iso2' => 'ME', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇲🇪'],
            ['name' => __('statamic::dictionary-countries.names.MSR'), 'iso3' => 'MSR', 'iso2' => 'MS', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇲🇸'],
            ['name' => __('statamic::dictionary-countries.names.MAR'), 'iso3' => 'MAR', 'iso2' => 'MA', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇲🇦'],
            ['name' => __('statamic::dictionary-countries.names.MOZ'), 'iso3' => 'MOZ', 'iso2' => 'MZ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇲🇿'],
            ['name' => __('statamic::dictionary-countries.names.MMR'), 'iso3' => 'MMR', 'iso2' => 'MM', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇲🇲'],
            ['name' => __('statamic::dictionary-countries.names.NAM'), 'iso3' => 'NAM', 'iso2' => 'NA', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇳🇦'],
            ['name' => __('statamic::dictionary-countries.names.NRU'), 'iso3' => 'NRU', 'iso2' => 'NR', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇳🇷'],
            ['name' => __('statamic::dictionary-countries.names.NPL'), 'iso3' => 'NPL', 'iso2' => 'NP', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇳🇵'],
            ['name' => __('statamic::dictionary-countries.names.NLD'), 'iso3' => 'NLD', 'iso2' => 'NL', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇳🇱'],
            ['name' => __('statamic::dictionary-countries.names.NCL'), 'iso3' => 'NCL', 'iso2' => 'NC', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['melanesia'], 'emoji' => '🇳🇨'],
            ['name' => __('statamic::dictionary-countries.names.NZL'), 'iso3' => 'NZL', 'iso2' => 'NZ', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['australia_new_zealand'], 'emoji' => '🇳🇿'],
            ['name' => __('statamic::dictionary-countries.names.NIC'), 'iso3' => 'NIC', 'iso2' => 'NI', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇳🇮'],
            ['name' => __('statamic::dictionary-countries.names.NER'), 'iso3' => 'NER', 'iso2' => 'NE', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇳🇪'],
            ['name' => __('statamic::dictionary-countries.names.NGA'), 'iso3' => 'NGA', 'iso2' => 'NG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇳🇬'],
            ['name' => __('statamic::dictionary-countries.names.NIU'), 'iso3' => 'NIU', 'iso2' => 'NU', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇳🇺'],
            ['name' => __('statamic::dictionary-countries.names.NFK'), 'iso3' => 'NFK', 'iso2' => 'NF', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['australia_new_zealand'], 'emoji' => '🇳🇫'],
            ['name' => __('statamic::dictionary-countries.names.PRK'), 'iso3' => 'PRK', 'iso2' => 'KP', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇰🇵'],
            ['name' => __('statamic::dictionary-countries.names.MNP'), 'iso3' => 'MNP', 'iso2' => 'MP', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇲🇵'],
            ['name' => __('statamic::dictionary-countries.names.NOR'), 'iso3' => 'NOR', 'iso2' => 'NO', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇳🇴'],
            ['name' => __('statamic::dictionary-countries.names.OMN'), 'iso3' => 'OMN', 'iso2' => 'OM', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇴🇲'],
            ['name' => __('statamic::dictionary-countries.names.PAK'), 'iso3' => 'PAK', 'iso2' => 'PK', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇵🇰'],
            ['name' => __('statamic::dictionary-countries.names.PLW'), 'iso3' => 'PLW', 'iso2' => 'PW', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['micronesia'], 'emoji' => '🇵🇼'],
            ['name' => __('statamic::dictionary-countries.names.PSE'), 'iso3' => 'PSE', 'iso2' => 'PS', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇵🇸'],
            ['name' => __('statamic::dictionary-countries.names.PAN'), 'iso3' => 'PAN', 'iso2' => 'PA', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['central_america'], 'emoji' => '🇵🇦'],
            ['name' => __('statamic::dictionary-countries.names.PNG'), 'iso3' => 'PNG', 'iso2' => 'PG', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['melanesia'], 'emoji' => '🇵🇬'],
            ['name' => __('statamic::dictionary-countries.names.PRY'), 'iso3' => 'PRY', 'iso2' => 'PY', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇵🇾'],
            ['name' => __('statamic::dictionary-countries.names.PER'), 'iso3' => 'PER', 'iso2' => 'PE', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇵🇪'],
            ['name' => __('statamic::dictionary-countries.names.PHL'), 'iso3' => 'PHL', 'iso2' => 'PH', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇵🇭'],
            ['name' => __('statamic::dictionary-countries.names.PCN'), 'iso3' => 'PCN', 'iso2' => 'PN', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇵🇳'],
            ['name' => __('statamic::dictionary-countries.names.POL'), 'iso3' => 'POL', 'iso2' => 'PL', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇵🇱'],
            ['name' => __('statamic::dictionary-countries.names.PRT'), 'iso3' => 'PRT', 'iso2' => 'PT', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇵🇹'],
            ['name' => __('statamic::dictionary-countries.names.PRI'), 'iso3' => 'PRI', 'iso2' => 'PR', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇵🇷'],
            ['name' => __('statamic::dictionary-countries.names.QAT'), 'iso3' => 'QAT', 'iso2' => 'QA', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇶🇦'],
            ['name' => __('statamic::dictionary-countries.names.REU'), 'iso3' => 'REU', 'iso2' => 'RE', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇷🇪'],
            ['name' => __('statamic::dictionary-countries.names.ROU'), 'iso3' => 'ROU', 'iso2' => 'RO', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇷🇴'],
            ['name' => __('statamic::dictionary-countries.names.RUS'), 'iso3' => 'RUS', 'iso2' => 'RU', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇷🇺'],
            ['name' => __('statamic::dictionary-countries.names.RWA'), 'iso3' => 'RWA', 'iso2' => 'RW', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇷🇼'],
            ['name' => __('statamic::dictionary-countries.names.SHN'), 'iso3' => 'SHN', 'iso2' => 'SH', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇸🇭'],
            ['name' => __('statamic::dictionary-countries.names.KNA'), 'iso3' => 'KNA', 'iso2' => 'KN', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇰🇳'],
            ['name' => __('statamic::dictionary-countries.names.LCA'), 'iso3' => 'LCA', 'iso2' => 'LC', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇱🇨'],
            ['name' => __('statamic::dictionary-countries.names.SPM'), 'iso3' => 'SPM', 'iso2' => 'PM', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇵🇲'],
            ['name' => __('statamic::dictionary-countries.names.VCT'), 'iso3' => 'VCT', 'iso2' => 'VC', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇻🇨'],
            ['name' => __('statamic::dictionary-countries.names.BLM'), 'iso3' => 'BLM', 'iso2' => 'BL', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇧🇱'],
            ['name' => __('statamic::dictionary-countries.names.MAF'), 'iso3' => 'MAF', 'iso2' => 'MF', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇲🇫'],
            ['name' => __('statamic::dictionary-countries.names.WSM'), 'iso3' => 'WSM', 'iso2' => 'WS', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇼🇸'],
            ['name' => __('statamic::dictionary-countries.names.SMR'), 'iso3' => 'SMR', 'iso2' => 'SM', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇸🇲'],
            ['name' => __('statamic::dictionary-countries.names.STP'), 'iso3' => 'STP', 'iso2' => 'ST', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇸🇹'],
            ['name' => __('statamic::dictionary-countries.names.SAU'), 'iso3' => 'SAU', 'iso2' => 'SA', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇸🇦'],
            ['name' => __('statamic::dictionary-countries.names.SEN'), 'iso3' => 'SEN', 'iso2' => 'SN', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇸🇳'],
            ['name' => __('statamic::dictionary-countries.names.SRB'), 'iso3' => 'SRB', 'iso2' => 'RS', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇷🇸'],
            ['name' => __('statamic::dictionary-countries.names.SYC'), 'iso3' => 'SYC', 'iso2' => 'SC', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇸🇨'],
            ['name' => __('statamic::dictionary-countries.names.SLE'), 'iso3' => 'SLE', 'iso2' => 'SL', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇸🇱'],
            ['name' => __('statamic::dictionary-countries.names.SGP'), 'iso3' => 'SGP', 'iso2' => 'SG', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇸🇬'],
            ['name' => __('statamic::dictionary-countries.names.SXM'), 'iso3' => 'SXM', 'iso2' => 'SX', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇸🇽'],
            ['name' => __('statamic::dictionary-countries.names.SVK'), 'iso3' => 'SVK', 'iso2' => 'SK', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇸🇰'],
            ['name' => __('statamic::dictionary-countries.names.SVN'), 'iso3' => 'SVN', 'iso2' => 'SI', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇸🇮'],
            ['name' => __('statamic::dictionary-countries.names.SLB'), 'iso3' => 'SLB', 'iso2' => 'SB', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['melanesia'], 'emoji' => '🇸🇧'],
            ['name' => __('statamic::dictionary-countries.names.SOM'), 'iso3' => 'SOM', 'iso2' => 'SO', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇸🇴'],
            ['name' => __('statamic::dictionary-countries.names.ZAF'), 'iso3' => 'ZAF', 'iso2' => 'ZA', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇿🇦'],
            ['name' => __('statamic::dictionary-countries.names.SGS'), 'iso3' => 'SGS', 'iso2' => 'GS', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇬🇸'],
            ['name' => __('statamic::dictionary-countries.names.KOR'), 'iso3' => 'KOR', 'iso2' => 'KR', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇰🇷'],
            ['name' => __('statamic::dictionary-countries.names.SSD'), 'iso3' => 'SSD', 'iso2' => 'SS', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['central_africa'], 'emoji' => '🇸🇸'],
            ['name' => __('statamic::dictionary-countries.names.ESP'), 'iso3' => 'ESP', 'iso2' => 'ES', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇪🇸'],
            ['name' => __('statamic::dictionary-countries.names.LKA'), 'iso3' => 'LKA', 'iso2' => 'LK', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['southern_asia'], 'emoji' => '🇱🇰'],
            ['name' => __('statamic::dictionary-countries.names.SDN'), 'iso3' => 'SDN', 'iso2' => 'SD', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇸🇩'],
            ['name' => __('statamic::dictionary-countries.names.SUR'), 'iso3' => 'SUR', 'iso2' => 'SR', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇸🇷'],
            ['name' => __('statamic::dictionary-countries.names.SJM'), 'iso3' => 'SJM', 'iso2' => 'SJ', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇸🇯'],
            ['name' => __('statamic::dictionary-countries.names.SWZ'), 'iso3' => 'SWZ', 'iso2' => 'SZ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['southern_africa'], 'emoji' => '🇸🇿'],
            ['name' => __('statamic::dictionary-countries.names.SWE'), 'iso3' => 'SWE', 'iso2' => 'SE', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇸🇪'],
            ['name' => __('statamic::dictionary-countries.names.CHE'), 'iso3' => 'CHE', 'iso2' => 'CH', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['western_europe'], 'emoji' => '🇨🇭'],
            ['name' => __('statamic::dictionary-countries.names.SYR'), 'iso3' => 'SYR', 'iso2' => 'SY', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇸🇾'],
            ['name' => __('statamic::dictionary-countries.names.TWN'), 'iso3' => 'TWN', 'iso2' => 'TW', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['eastern_asia'], 'emoji' => '🇹🇼'],
            ['name' => __('statamic::dictionary-countries.names.TJK'), 'iso3' => 'TJK', 'iso2' => 'TJ', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['central_asia'], 'emoji' => '🇹🇯'],
            ['name' => __('statamic::dictionary-countries.names.TZA'), 'iso3' => 'TZA', 'iso2' => 'TZ', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇹🇿'],
            ['name' => __('statamic::dictionary-countries.names.THA'), 'iso3' => 'THA', 'iso2' => 'TH', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇹🇭'],
            ['name' => __('statamic::dictionary-countries.names.TGO'), 'iso3' => 'TGO', 'iso2' => 'TG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['western_africa'], 'emoji' => '🇹🇬'],
            ['name' => __('statamic::dictionary-countries.names.TKL'), 'iso3' => 'TKL', 'iso2' => 'TK', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇹🇰'],
            ['name' => __('statamic::dictionary-countries.names.TON'), 'iso3' => 'TON', 'iso2' => 'TO', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇹🇴'],
            ['name' => __('statamic::dictionary-countries.names.TTO'), 'iso3' => 'TTO', 'iso2' => 'TT', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇹🇹'],
            ['name' => __('statamic::dictionary-countries.names.TUN'), 'iso3' => 'TUN', 'iso2' => 'TN', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇹🇳'],
            ['name' => __('statamic::dictionary-countries.names.TUR'), 'iso3' => 'TUR', 'iso2' => 'TR', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇹🇷'],
            ['name' => __('statamic::dictionary-countries.names.TKM'), 'iso3' => 'TKM', 'iso2' => 'TM', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['central_asia'], 'emoji' => '🇹🇲'],
            ['name' => __('statamic::dictionary-countries.names.TCA'), 'iso3' => 'TCA', 'iso2' => 'TC', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇹🇨'],
            ['name' => __('statamic::dictionary-countries.names.TUV'), 'iso3' => 'TUV', 'iso2' => 'TV', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇹🇻'],
            ['name' => __('statamic::dictionary-countries.names.UGA'), 'iso3' => 'UGA', 'iso2' => 'UG', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇺🇬'],
            ['name' => __('statamic::dictionary-countries.names.UKR'), 'iso3' => 'UKR', 'iso2' => 'UA', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['eastern_europe'], 'emoji' => '🇺🇦'],
            ['name' => __('statamic::dictionary-countries.names.ARE'), 'iso3' => 'ARE', 'iso2' => 'AE', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇦🇪'],
            ['name' => __('statamic::dictionary-countries.names.GBR'), 'iso3' => 'GBR', 'iso2' => 'GB', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['northern_europe'], 'emoji' => '🇬🇧'],
            ['name' => __('statamic::dictionary-countries.names.USA'), 'iso3' => 'USA', 'iso2' => 'US', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇺🇸'],
            ['name' => __('statamic::dictionary-countries.names.UMI'), 'iso3' => 'UMI', 'iso2' => 'UM', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['northern_america'], 'emoji' => '🇺🇲'],
            ['name' => __('statamic::dictionary-countries.names.URY'), 'iso3' => 'URY', 'iso2' => 'UY', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇺🇾'],
            ['name' => __('statamic::dictionary-countries.names.UZB'), 'iso3' => 'UZB', 'iso2' => 'UZ', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['central_asia'], 'emoji' => '🇺🇿'],
            ['name' => __('statamic::dictionary-countries.names.VUT'), 'iso3' => 'VUT', 'iso2' => 'VU', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['melanesia'], 'emoji' => '🇻🇺'],
            ['name' => __('statamic::dictionary-countries.names.VAT'), 'iso3' => 'VAT', 'iso2' => 'VA', 'region' => $this->regions['europe'], 'subregion' => $this->subregions['southern_europe'], 'emoji' => '🇻🇦'],
            ['name' => __('statamic::dictionary-countries.names.VEN'), 'iso3' => 'VEN', 'iso2' => 'VE', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['south_america'], 'emoji' => '🇻🇪'],
            ['name' => __('statamic::dictionary-countries.names.VNM'), 'iso3' => 'VNM', 'iso2' => 'VN', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['south_eastern_asia'], 'emoji' => '🇻🇳'],
            ['name' => __('statamic::dictionary-countries.names.VGB'), 'iso3' => 'VGB', 'iso2' => 'VG', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇻🇬'],
            ['name' => __('statamic::dictionary-countries.names.VIR'), 'iso3' => 'VIR', 'iso2' => 'VI', 'region' => $this->regions['americas'], 'subregion' => $this->subregions['caribbean'], 'emoji' => '🇻🇮'],
            ['name' => __('statamic::dictionary-countries.names.WLF'), 'iso3' => 'WLF', 'iso2' => 'WF', 'region' => $this->regions['oceania'], 'subregion' => $this->subregions['polynesia'], 'emoji' => '🇼🇫'],
            ['name' => __('statamic::dictionary-countries.names.ESH'), 'iso3' => 'ESH', 'iso2' => 'EH', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['northern_africa'], 'emoji' => '🇪🇭'],
            ['name' => __('statamic::dictionary-countries.names.YEM'), 'iso3' => 'YEM', 'iso2' => 'YE', 'region' => $this->regions['asia'], 'subregion' => $this->subregions['western_asia'], 'emoji' => '🇾🇪'],
            ['name' => __('statamic::dictionary-countries.names.ZMB'), 'iso3' => 'ZMB', 'iso2' => 'ZM', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇿🇲'],
            ['name' => __('statamic::dictionary-countries.names.ZWE'), 'iso3' => 'ZWE', 'iso2' => 'ZW', 'region' => $this->regions['africa'], 'subregion' => $this->subregions['eastern_africa'], 'emoji' => '🇿🇼'],
        ];
    }
}
