<?php

return [
    'cheatsheet' => '
<p>Markdown ist eine Text-zu-HTML-Auszeichnungssyntax für Webautoren. Mit Markdown kannst du in einem einfachen, reinen Textformat schreiben, welches leicht zu lesen ist und in korrektes HTML konvertiert wird.</p>
<h3>Überschriften</h3>
<pre class="language-markdown"><code># Dies ist eine H1
## Dies ist eine H2
### Dies ist eine H3…
</code></pre>


<h3>Fett &amp; Kursiv</h3>
<pre class="language-markdown"><code>Du kannst Wörter *kursiv*, **fett**, oder _**beides**_ machen.</code></pre>

<h3>Links</h3>
<pre class="language-markdown"><code>Dies ist ein [Beispiel-Link](http://example.com).</code></pre>

<h3>Code</h3>
<p>Umschliesse deinen Code mit drei Backticks (<code>```</code>) auf der Zeile davor und danach.</p>

<pre class="language-markdown"><code>```
dies: \'ist etwas YAML\'
```</code></pre>

<p>Du kannst auch Code inline hinzufügen, indem du den Inhalt mit je einem einfachen Backtick (<code>`</code>) umschliesst.</p>

<h3>Zitate</h3>
<p>Erstelle ein Zitat, indem du den Text mit <code>>&nbsp;</code> beginnst.</p>
<pre class="language-markdown"><code>> Dies wird ein Zitat.</code></pre>

<h3>Bilder</h3>
<pre class="language-markdown"><code>![Alt-Text](http://example.com/image.jpg)</code></pre>

<h3>Ungeordnete Listen</h3>
<pre class="language-markdown"><code>- Brötli
- Gipfeli
- Zöpfli
</code></pre>

<h3>Geordnete Listen</h3>
<pre class="language-markdown"><code>1. Aareböötle
2. Gläcele
3. u när no chli Sünnele</code></pre>

<h3>Tabellen</h3>
<pre class="language-markdown"><code>Erste Titelzelle  | Zweite Titelzelle
------------- | -------------
Zelleninhalt  | Zelleninhalt
Zelleninhalt  | Zelleninhalt</code></pre>',

];
