<?php use function Statamic\trans as __; ?>


<?php $__env->startSection('title', __('Updater')); ?>

<?php $__env->startSection('content'); ?>

    <?php if($requestError): ?>

        <div class="no-results md:pt-30 max-w-2xl mx-auto">
            <div class="flex flex-wrap items-center">
                <div class="w-full md:w-1/2">
                    <h1 class="mb-8"><?php echo e(__('Updates')); ?></h1>
                    <p class="text-gray-700 leading-normal mb-8 text-lg antialiased">
                        <?php echo e(__('statamic::messages.outpost_issue_try_later')); ?>

                    </p>
                    <a href="<?php echo e(cp_route('updater')); ?>"
                        class="btn-primary btn-lg"><?php echo e(__('Try again')); ?></a>
                </div>
                <div class="hidden md:block w-1/2 rtl:pr-16 ltr:pl-16">
                    <?php echo Statamic::svg('empty/navigation') ?>
                </div>
            </div>
        </div>

    <?php else: ?>

        <div class="flex mb-6">
            <h1 class="flex-1"><?php echo e(__('Updates')); ?></h1>
        </div>

        <h6 class="mt-8"><?php echo e(__('Core')); ?></h6>
        <div class="card p-0 mt-2">
            <table class="data-table">
                <tr>
                    <td class="w-64"><a href="<?php echo e(route('statamic.cp.updater.product', 'statamic')); ?>" class="text-blue font-bold"><?php echo e(__('Statamic')); ?></a></td>
                    <td><?php echo e($statamic->currentVersion()); ?></td>
                    <?php if($count = $statamic->availableUpdatesCount()): ?>
                        <td class="rtl:text-left ltr:text-right"><span class="badge-sm bg-green-600 btn-xs"><?php echo e(trans_choice('1 update|:count updates', $count)); ?></span></td>
                    <?php else: ?>
                        <td class="rtl:text-left ltr:text-right"><?php echo e(__('Up to date')); ?></td>
                    <?php endif; ?>
                </tr>
            </table>
        </div>

        <?php if($addons->count()): ?>
            <h6 class="mt-8"><?php echo e(__('Addons')); ?></h6>
            <div class="card p-0 mt-2">
                <table class="data-table">
                    <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="w-64"><a href="<?php echo e(route('statamic.cp.updater.product', $addon -> slug())); ?>"
                                class="text-blue font-bold rtl:ml-2 ltr:mr-2"><?php echo e($addon -> name()); ?></a>
                        <td><?php echo e($addon -> version()); ?></td>
                        <?php if($count = $addon->changelog()->availableUpdatesCount()): ?>
                        <td class="rtl:text-left ltr:text-right"><span
                                class="badge-sm bg-green-600 btn-xs"><?php echo e(trans_choice('1 update|:count updates', $count)); ?></span></td>
                        <?php else: ?>
                        <td class="rtl:text-left ltr:text-right"><?php echo e(__('Up to date')); ?></td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        <?php endif; ?>

        <?php if($unlistedAddons->count()): ?>
            <h6 class="mt-8"><?php echo e(__('Unlisted Addons')); ?></h6>
            <div class="card p-0 mt-2">
                <table class="data-table">
                    <?php $__currentLoopData = $unlistedAddons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="w-64"><?php echo e($addon->name()); ?></td>
                            <td><?php echo e($addon->version()); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        <?php endif; ?>

        <?php echo $__env->make('statamic::partials.docs-callout', [
            'topic' => __('Updates'),
            'url' => Statamic::docsUrl('updating')
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('statamic::layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\utente\Herd\brainiumgames2.0\vendor\statamic\cms\src\Providers/../../resources/views/updater/index.blade.php ENDPATH**/ ?>