import { createApp } from 'vue'
// import the root component App from a single-file component.
import GamesGrid from './components/GamesGrid.vue';

import { Carousel } from "@fancyapps/ui/dist/carousel/carousel.esm.js";
import "@fancyapps/ui/dist/carousel/carousel.css";

import { Thumbs } from "@fancyapps/ui/dist/carousel/carousel.thumbs.esm.js";
import "@fancyapps/ui/dist/carousel/carousel.thumbs.css";

import { Fancybox } from "@fancyapps/ui";
import "@fancyapps/ui/dist/fancybox/fancybox.css";

const gamesgrid = createApp(GamesGrid);

gamesgrid.mount('#gamesgrid');

const imagesContainer = document.getElementById("gallery") ?? null;
const videosContainer = document.getElementById("videosCarousel") ?? null;
const options = { 
    
    infinite: true,
    /* Thumbs: {
        type: "classic",
    }, */
    center: true,
    Dots: {
        minCount: 0,
    },
};

if (imagesContainer != null) {
    //new Carousel(imagesContainer, options, { Thumbs });
    new Carousel(imagesContainer, options);
    Fancybox.bind('[data-fancybox="gallery"]');
}
 if (videosContainer != null) {
    new Carousel(videosContainer, options);
} 

const images = document.getElementById("gallery") ?? null;
const videos = document.getElementById("videosCarousel") ?? null;

const toggler = document.querySelectorAll('.toggler') ?? null;

const mobileNavToggle = document.querySelectorAll('.mobileNavToggle') ?? null;
//const mtogg = document.querySelectorAll('#m-togg') ?? null;
const mobileMenu = document.querySelectorAll('#mobileNavContent') ?? null;
const mobileMenuClose = document.querySelectorAll('.close') ?? null;
const navHeader = document.querySelectorAll('.mobile-nav') ?? null;


//console.log(toggler[0].dataset.target);

toggler.forEach((toggle) => {
    toggle.addEventListener("click", (e) => {
        e.preventDefault();
        //console.log("clicked");
        //toggle.parentNode.classList.toggle("active");
        if(toggle.id === "imagesToggler") {
            const videosToggler = document.getElementById("videosToggler");
            videosToggler.parentNode.classList.remove('active');
            toggle.parentNode.classList.add('active');

            videos.classList.remove('show');
            videos.classList.add('hide');
            images.classList.add('show');


            //console.log("images toggler");

        }
        if(toggle.id === "videosToggler") {
            const imagesToggler = document.getElementById("imagesToggler");
            imagesToggler.parentNode.classList.remove('active');
            toggle.parentNode.classList.add('active');

            images.classList.remove('show');
            images.classList.add('hide')
            videos.classList.add('show');
        }

    });
});

console.log(mobileNavToggle[0]);

mobileNavToggle[0].addEventListener("click", (e) => {
    e.preventDefault();

    if(navHeader[0].classList.contains('slide-in-top')) {
        navHeader[0].classList.remove('slide-in-top');
    }

    if(mobileMenu[0].classList.contains('slide-out-bottom')) {
        mobileMenu[0].classList.remove('slide-out-bottom');
        mobileMenu[0].style.display = 'none';
    }

    navHeader[0].classList.add('slide-out-top');
    document.body.style.paddingTop = 0;
    mobileMenu[0].style.display = 'block';
    //mobileMenu[0].classList.add('show');
    mobileMenu[0].classList.add('slide-in-bottom');
    mobileMenu[0].style.display = 'block';



});

mobileMenuClose[0].addEventListener("click", (e) => {
    e.preventDefault();
    navHeader[0].classList.remove('slide-out-top');
    mobileMenu[0].classList.remove('slide-in-bottom');

    mobileMenu[0].classList.add('slide-out-bottom');
    //mobileMenu[0].classList.remove('slide-out-bottom');

    //mobileMenu[0].style.display = 'none';
      

    

    navHeader[0].classList.add('slide-in-top');
    document.body.style.paddingTop = '111px';
    //navHeader[0].classList.remove('slide-in-top');

});