<?php

namespace App\Listeners;

use Statamic\Events\EntryCreated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Statamic\Facades\Entry;
use Carbon\Carbon;

class CreatePolicy
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //


    }

    /**
     * Handle the event.
     */
    public function handle(EntryCreated $event): void
    {
        if($event->entry->collection->handle == 'games') {
            $policy = Entry::make()->collection('policies')->slug($event->entry->slug.'-privacy-policy');
            $policy->date(Carbon::today()->toDateString());
            $policy->title = $event->entry->title . " Privacy Policy";
            $policy->published(true);
            $policy->locale('default');
            $policy->blueprint('policy');
            $policy->related_game = $event->entry->id;
            $policy->save();
            $event->entry->related_policy = $policy->id;
            $event->entry->save();
        }
    }
}
