<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureApiToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
          if ($request->hasHeader('X-Header-Token')) {
            if ($request->header('X-Header-Token') == env('APP_CUSTOM_API_KEY')) {
                return $next($request);
            } else {
                return redirect('/');
            }
        } else {
            return redirect('/');
        } 
 
        return $next($request);
    }
}
