<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Statamic\Facades\Collection;
use Statamic\Facades\Entry;
use Statamic\Facades\Taxonomy;
use Carbon\Carbon;

use Illuminate\Support\Str;


class ApiController extends Controller
{
    //$app_token = env('APP_CUSTOM_API_KEY');

    public function games(Request $request) {

        $genre = $request->genre ? $request->genre : '';
        //$platform = $request->platform ? $request->platform : '';
        $device = $request->platform ? $request->platform : '';
        $terms = $request->terms ? $request->terms : '';

        $games = Entry::query()
        ->where('collection', 'games')
        ->whereStatus('published')
        //->where('release_date', '!=', null)
        ->where('release_date', '<=', Carbon::today()->toDateString())
        ->where('release_date', '!=', null)

        ->where('title', 'like', '%' . $terms . '%')

        ->where(function($query) use($genre,$device) {
            if(!empty($genre)) {
            $query->whereJsonContains('genres_tax', $genre);
            }
        })
        ->where(function($query) use($genre,$device) {
            if(!empty($device)) {
            $query->whereJsonContains('devices_tax', $device);
            }
        })
 
        ->get();

        return response()->json($games);
        //return $request->genre;
    }

    public function genres() {
        $genres = Taxonomy::find('genres_tax');


        //return response()->json($genres->queryTerms()->get());
        return $genres->queryTerms()->get();
    }

    public function platforms() {
        $platforms = Taxonomy::find('devices_tax');

        return response()->json($platforms->queryTerms()->get());
    }
}
